# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Math/Trig.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Drought-PET-Thornthwaite
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.50
Release: alt1
Summary: Calculate potential evapotranspiration (PET) using the Thornthwaite method
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AA/AALLGOOD/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Evapotranspiration is the amount of water removed from the soil due to both evaporation and 
vegetative consumption. Factors such as sun angle, temperature, soil type, the amount of 
available water, and the types of vegetation all affect the amount of evapotranspiration 
that occurs in a given location. The potential evapotranspiration (PET) is defined as the 
amount of evapotranspiration that would occur under a defined set of conditions if the amount 
of available water in the soil was limitless and accessible. The PET is a component of various 
drought and water balance models. Numerous techniques have been developed to calculate 
and estimate potential evapotranspiration.

The Drought::PET::Thornthwaite package provides functions that can calculate the PET 
based on the Thornthwaite Equation (Thornthwaite 1948). This equation estimates PET based 
on the day of year, the latitude of the target location, the temperature observed during 
the period for which PET is calculated, and a monthly temperature-based climatological index 
specific to the target region. This index is typically called the Thornthwaite heat index, 
or the temperature efficiency index. The documentation for this package refers to this index 
as the temperature efficiency index (TEI).

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.pod Changes LICENSE ignore.txt
%perl_vendor_privlib/D*

%changelog
