%define module_name EAI-Wrap
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Archive/Extract.pm) perl(Archive/Zip.pm) perl(DBD/ODBC.pm) perl(DBI.pm) perl(Data/XLSX/Parser.pm) perl(Excel/Writer/XLSX.pm) perl(ExtUtils/MakeMaker.pm) perl(HTML/HTML5/Entities.pm) perl(Log/Dispatch/Email/MIMELite.pm) perl(Log/Log4perl.pm) perl(MIME/Lite.pm) perl(Net/FTP.pm) perl(Net/SFTP/Foreign.pm) perl(Spreadsheet/ParseExcel.pm) perl(Spreadsheet/WriteExcel.pm) perl(Test/File.pm) perl(Test/More.pm) perl(Test/Timer.pm) perl(Text/CSV.pm) perl(Text/Glob.pm) perl(Time/Local.pm) perl(Time/Piece.pm) perl(XML/LibXML.pm) perl(XML/LibXML/Debugging.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.919
Release: alt1
Summary: framework for easy creation of Enterprise Application Integration tasks
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RK/RKAPL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
EAI::Wrap provides a framework for defining EAI jobs directly in Perl, sparing the creator of low-level tasks as FTP-Fetching, file-parsing and storing into a database.
It also can be used to handle other workflows, like creating files from the database and uploading to FTP-Servers or using other externally provided tools.

The definition is done by first setting up configuration hashes and then providing a high-level scripting of the job itself using the provided API (although any perl code is welcome here!).

EAI::Wrap has a lot of infrastructure already included, like logging using Log4perl, database handling with the DBI manpage and the DBD::ODBC manpage, FTP services using the Net::SFTP::Foreign manpage, file parsing using the Text::CSV manpage (text files), the Data::XLSX::Parser manpage and the Spreadsheet::ParseExcel manpage (excel files), the XML::LibXML manpage (xml files), file writing with the Spreadsheet::WriteExcel manpage and the Excel::Writer::XLSX manpage (excel files), the Text::CSV manpage (text files).

Furthermore it provides very flexible commandline options, allowing almost all configurations to be set on the commandline.
Commandline options (e.g. additional information passed on with the interactive option) of the task script are fetched at INIT allowing use of options within the configuration, e.g. $opt{process}{interactive_startdate} for a passed start date.

Also the logging configured in `$ENV{EAI_WRAP_CONFIG_PATH}/log.config' (logfile root path set in `$ENV{EAI_WRAP_CONFIG_PATH}/site.config') starts immediately at INIT of the task script, to use a logger, simply make a call to get_logger(). For the logging configuration, see the EAI::Common manpage, setupLogging.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE CONTRIBUTING README.md Changes
%perl_vendor_privlib/E*

%changelog
