%define module_name ETL-Pipeline
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Data/DPath.pm) perl(Data/Traverse.pm) perl(ExtUtils/CBuilder.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(List/AllUtils.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(MooseX/Types/Path/Class.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Path/Class.pm) perl(Path/Class/Rule.pm) perl(Regexp/Common.pm) perl(Spreadsheet/ParseExcel.pm) perl(Spreadsheet/ParseExcel/Utility.pm) perl(Spreadsheet/XLSX.pm) perl(String/Util.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Text/CSV.pm) perl(Try/Tiny.pm) perl(XML/Bare.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 3.10_a
Release: alt1
Summary: Extract-Transform-Load pattern for data file conversions
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RB/RBWOHLFAR/%{module_name}-3.10-a.tar.gz
BuildArch: noarch

%description
ETL stands for *Extract-Transform-Load*. ETL isn't just for Data
Warehousing. ETL works on almost any type of data conversion. You read the
source, translate the data for your target, and store the result.

By dividing a conversion into 3 steps, we isolate the input from the output...

=over

=item * Centralizes data formatting and validation.

=item * Makes new input formats a breeze.

=item * Makes new outputs just as easy.

=back

ETL::Pipeline takes your data files from extract to load. It reads an input
source, translates the data, and writes it to an output destination. For
example, I use the these pipelines for reading an Excel spread sheet (input)
and saving the information in an SQL database (output).

  use ETL::Pipeline;
  ETL::Pipeline->new( {
    work_in   => {search => 'C:\Data', find => qr/Ficticious/},
    input     => ['Excel', find => qr/\.xlsx?$/],
    mapping   => {Name => 'A', Complaint => 'B', ID => 'C'},
    constants => {Client => 1, Type => 'Complaint'}
    output    => ['SQL', table => 'NewData']
  } )->process;

Or like this, calling the methods instead of through the constructor...

  use ETL::Pipeline;
  my $etl = ETL::Pipeline->new;
  $etl->work_in  ( search => 'C:\Data', find => qr/Ficticious/ );
  $etl->input    ( 'Excel', find => qr/\.xlsx?$/               );
  $etl->mapping  ( Name => 'A', Complaint => 'B', ID => 'C'    );
  $etl->constants( Client => 1, Type => 'Complaint'            );
  $etl->output   ( 'SQL', table => 'NewData'                   );
  $etl->process;


%prep
%setup -q -n %{module_name}-3.10

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README CONTRIBUTING.md
%perl_vendor_privlib/E*

%changelog
