Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(overload.pm) perl-devel perl-podlators
# END SourceDeps(oneline)
Name:           perl-ElasticSearch
Version:        0.66
Release:        alt1_1
Summary:        API for communicating with ElasticSearch
License:        GPL+ or Artistic

URL:            http://search.cpan.org/dist/ElasticSearch/
Source0:        http://www.cpan.org/authors/id/D/DR/DRTECH/ElasticSearch-%{version}.tar.gz

BuildArch:      noarch
BuildRequires:  perl(Any/URI/Escape.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(ElasticSearch/SearchBuilder.pm)
BuildRequires:  perl(Encode.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(File/Path.pm)
BuildRequires:  perl(File/Spec/Functions.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(HTTP/Lite.pm)
BuildRequires:  perl(HTTP/Request.pm)
BuildRequires:  perl(HTTP/Tiny.pm)
BuildRequires:  perl(IO/Handle.pm)
BuildRequires:  perl(IO/Socket.pm)
BuildRequires:  perl(IO/Uncompress/Inflate.pm)
BuildRequires:  perl(JSON.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(List/Util.pm)
BuildRequires:  perl(LWP/ConnCache.pm)
BuildRequires:  perl(LWP/UserAgent.pm)
BuildRequires:  perl(parent.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(Test/Differences.pm)
BuildRequires:  perl(Test/Exception.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(URI.pm)
BuildRequires:  perl(YAML.pm)


# ElasticSearch::RequestParser is used as a poor man's Role, ie those methods
# are being applied to the ElasticSearch class, rather than being in their own
# class. (https://github.com/clintongormley/ElasticSearch.pm/issues/35)
Provides:       perl(ElasticSearch/RequestParser.pm) = %{version}


Source44: import.info

%description
ElasticSearch is an Open Source (Apache 2 license), distributed, RESTful
Search Engine based on Lucene, and built for the cloud, with a JSON API.
This perl module is a thin API which makes it easy to communicate with
an ElasticSearch cluster.

%prep
%setup -q -n ElasticSearch-%{version}

%build
%{__perl} Makefile.PL INSTALLMAN1DIR=%_man1dir INSTALLDIRS=vendor
make %{?_smp_mflags}

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT

find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;

# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc AUTHORS Changes LICENSE README
%{perl_vendor_privlib}/*

%changelog
