%define module_name Elasticsearch-Model
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Load.pm) perl(DateTime.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/Socket/INET.pm) perl(IPC/System/Simple.pm) perl(List/AllUtils.pm) perl(Module/Find.pm) perl(Moose.pm) perl(Moose/Exporter.pm) perl(Moose/Role.pm) perl(Moose/Util/TypeConstraints.pm) perl(MooseX/Types.pm) perl(MooseX/Types/Moose.pm) perl(MooseX/Types/Structured.pm) perl(Search/Elasticsearch.pm) perl(Test/Class/Load.pm) perl(Test/Class/Most.pm) perl(Test/Moose.pm) perl(Test/Most.pm) perl(Test/Warnings.pm) perl(Try/Tiny.pm) perl(lib.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.5
Release: alt1
Summary: Does one thing only: helps to deploy a Moose model and accompanying document classes to Elasticsear...
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AM/AMIRI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is meant to be used very much like the ElasticSearchX::Model manpage, before it was deprecated. In fact, most of the code is borrowed from that module.

All the changes I have made are aimed at two things:

=over

=item 1

Compatibility with Elasticsearch 6+

=item 2

*Mapping, period.* Classes to index is all that this distribution does. We do not take data from elasticsearch and wrap it in the document type classes. We do not handle index aliasing, either, which can be quite complicated. For aliasing, however, `deploy_to' will allow you to specify the name of the index you will be creating, so that you can make the alias more directly.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/E*

%changelog
