%define module_version 0.10
%define module_name Email-Assets
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/UUID.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Compare.pm) perl(File/Slurp.pm) perl(File/Temp.pm) perl(File/Type.pm) perl(FindBin.pm) perl(MIME/Base64.pm) perl(MIME/Lite.pm) perl(MIME/Types.pm) perl(Moose.pm) perl(Test/Differences.pm) perl(Test/Exception.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: Manage assets for Email
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/T/TE/TEEJAY/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
use Email::Assets;

   my $assets = Email::Assets->new( base => [ $uri_root, $dir_root ] );

   # Email::Assets will automatically detect the type based on the extension
   my $asset = $assets->include("/static/foo.gif");

   # or

   my $asset = $assets->include_base64( $image_base64 );

   # This asset won't get attached twice, as Email::Assets will ignore repeats of a path
   my $cid = $assets->include("/static/foo.gif")->cid;

   # Or you can iterate (in order)
   for my $asset ($assets->exports) {
     print $asset->cid, "\n";
     my $mime_part = $asset->as_mime_part;
  }

..or in a template :

  <img src="cid://[%% assets.include('static/foo.gif').cid %%]">
  [%% # or %%]
  <img src="data:[%% assets.include('static/foo.gif', {inline_only => 1}).inline_data">
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/E*

%changelog
