# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Email-MIME-CreateHTML
%define upstream_version 1.042

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_4

Summary:    Finds resources via the filesystem
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Email/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(Data/Serializer.pm)
BuildRequires: perl(Email/Address.pm)
BuildRequires: perl(Email/MIME.pm)
BuildRequires: perl(Email/MIME/Creator.pm)
BuildRequires: perl(Email/Send.pm)
BuildRequires: perl(Encode.pm)
BuildRequires: perl(Exporter.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Copy.pm)
BuildRequires: perl(File/Slurp.pm)
BuildRequires: perl(File/Slurp/WithinPolicy.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(FindBin.pm)
BuildRequires: perl(HTML/Tagset.pm)
BuildRequires: perl(HTML/TokeParser/Simple.pm)
BuildRequires: perl(HTML/TreeBuilder/XPath.pm)
BuildRequires: perl(LWP/UserAgent.pm)
BuildRequires: perl(Log/Trace.pm)
BuildRequires: perl(MIME/Parser.pm)
BuildRequires: perl(MIME/Types.pm)
BuildRequires: perl(MIME/Words.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildRequires: perl(Test/Assertions.pm)
BuildRequires: perl(Test/Assertions/TestScript.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(URI/Escape.pm)
BuildRequires: perl(URI/WithBase.pm)
BuildRequires: perl(URI/file.pm)
BuildRequires: perl(common/sense.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(vars.pm)
BuildArch:  noarch
Source44: import.info

%description
This module allows you to build HTML emails, optionally with a text-only
alternative and embedded media objects. For example, an HTML email with an
alternative version in plain text and with all the required images
contained in the mail.

The HTML content is parsed looking for embeddable media objects. A resource
loading routine is used to fetch content from those URIs and replace the
URIs in the HTML with CIDs. The default resource loading routine is
deliberately conservative, only allowing resources to be fetched from the
local filesystem. It's possible and relatively straightforward to plug in a
custom resource loading routine that can resolve URIs using a broader range
of protocols. An example of one using LWP is given later in the the
/COOKBOOK manpage.

The MIME structure is then assembled, embedding the content of the
resources where appropriate. Note that this module does not send any mail,
it merely does the work of building the appropriate MIME message. The
message can be sent with the Email::Send manpage or any other mailer that
can be fed a string representation of an email message.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc COPYING Changes META.yml  README
%perl_vendor_privlib/*

%changelog
