# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/TW.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(Test.pm) perl(XSLoader.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm) perl-Encode-devel
# END SourceDeps(oneline)
%define module_version 0.35
%define module_name Encode-HanConvert
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.35
Release: alt7
Summary: Traditional and Simplified Chinese mappings
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AU/AUDREYT/%module_name-%module_version.tar.gz

%description
This module is an attempt to solve most common problems occured in
Traditional vs. Simplified Chinese conversion, in an efficient,
flexible way, without resorting to external tools or modules.

If you are using perl 5.7.2 or earlier, all Unicode-related functions
are disabled, and Encode::HanConvert::Perl is automagically loaded
and used instead. In that case, please consult the Encode::HanConvert::Perl manpage
instead.

After installing this module, you'll have two additional encoding
formats: `big5-simp' maps *Big5* into Unicode's Simplified Chinese
(and vice versa), and `gbk-trad' maps *GBK* (also known as *CP936*)
into Unicode's Traditional Chinese and back.

The module exports various `xxx_to_yyy' functions by default, where
xxx and yyy are one of `big5', `gb' (i.e. GBK/CP936), `simp'
(simplified Chinese unicode), or `trad' (traditional Chinese unicode).

You may also import `simple' and `trad', which are aliases for
`simp_to_trad' and `trad_to_simp'; this is provided as a drop-in
replacement for programs using the Lingua::ZH::HanConvert manpage.

Since this is built on the Encode manpage's architecture, you may also use
the line discipline syntax to perform the conversion implicitly
(before 5.7.3, you need to use 'cp936' in place of 'gbk'):

    require Encode::CN;
    open BIG5, ':encoding(big5-simp)', 'big5.txt';  # as simplified
    open EUC,  '>:encoding(gbk)',      'gbk.txt';   # as gbk
    print EUC, <BIG5>;

    require Encode::TW;
    open EUC,  ':encoding(gbk-trad)',  'gbk.txt';   # as traditional
    open BIG5, '>:encoding(big5)',     'big5.txt';  # as big-5
    print BIG5, <EUC>;

Or, more interestingly:

=for encoding big5

    use encoding 'big5-simp';
    print "III."; # prints simplified Chinese in unicode

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release
BuildArch: noarch

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes README AUTHORS
%perl_vendor_archlib/E*
%perl_vendor_autolib/*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
