%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Encode.pm) perl(Encode/Alias.pm) perl(Encode/CN.pm) perl(Encode/Encoding.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.60
%define module_name Encode-JP-Emoji
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.60
Release: alt1
Summary: Emoji encodings and cross-mapping tables in pure Perl
Group: Development/Perl
License: apache
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/K/KA/KAWASAKI/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module provides encodings which support emoji picture characters.

The first group of encodings uses carriers' private code points
as Perl's internal string which has UTF-8 flag on.

    Name                        Encoding    Octets Emoji    String Emoji
    --------------------------------------------------------------------
    x-sjis-emoji-docomo         Shift_JIS   DoCoMo          DoCoMo
    x-sjis-emoji-kddiapp        Shift_JIS   KDDI            KDDI(app)
    x-sjis-emoji-kddiweb        Shift_JIS   KDDI            KDDI(web)
    x-sjis-emoji-softbank2g     Shift_JIS   SoftBank(2G)    SoftBank
    x-sjis-emoji-softbank3g     Shift_JIS   SoftBank(3G)    SoftBank
    x-utf8-emoji-docomo         UTF-8       DoCoMo          DoCoMo
    x-utf8-emoji-kddiapp        UTF-8       KDDI(app)       KDDI(app)
    x-utf8-emoji-kddiweb        UTF-8       KDDI(web)       KDDI(web)
    x-utf8-emoji-softbank2g     UTF-8       SoftBank(2G)    SoftBank
    x-utf8-emoji-softbank3g     UTF-8       SoftBank(3G)    SoftBank
    --------------------------------------------------------------------

KDDI has two version of thier private code points.
KDDI(app) is official and documented version used in EZappli and character references.
KDDI(web), on the other hand, is undocumented version but used in UTF-8 web pages.
Use KDDI(web) encoding recommended in most cases.

SoftBank also has two version of thier emoji representations.
SoftBank(2G) uses escape sequence style.
SoftBank(3G) uses binary representations.
Use SoftBank(3G) encoding recommended in most cases.

The second group uses Googles's private code points internaly.
This means Google's encoding could be the interchange encoding for others.

    Name                        Encoding    Octets Emoji    String Emoji
    --------------------------------------------------------------------
    x-sjis-e4u-docomo           Shift_JIS   DoCoMo          Google
    x-sjis-e4u-kddiapp          Shift_JIS   KDDI            Google
    x-sjis-e4u-kddiweb          Shift_JIS   KDDI            Google
    x-sjis-e4u-softbank2g       Shift_JIS   SoftBank(2G)    Google
    x-sjis-e4u-softbank3g       Shift_JIS   SoftBank(3G)    Google
    x-utf8-e4u-docomo           UTF-8       DoCoMo          Google
    x-utf8-e4u-kddiapp          UTF-8       KDDI(app)       Google
    x-utf8-e4u-kddiweb          UTF-8       KDDI(web)       Google
    x-utf8-e4u-softbank2g       UTF-8       SoftBank(2G)    Google
    x-utf8-e4u-softbank3g       UTF-8       SoftBank(3G)    Google
    --------------------------------------------------------------------

The cross-carriers mapping tables are based on emoji4unicode, 
Emoji for Unicode, project on Google Code.
See more detail on http://code.google.com/p/emoji4unicode/ about the project.

The next group also uses Google's.

    Name                        Encoding    Octets Emoji    String Emoji
    --------------------------------------------------------------------
    x-utf8-e4u-unicode          UTF-8       Unicode Std.    Google
    x-utf8-e4u-google           UTF-8       Google          Google
    x-utf8-e4u-mixed            UTF-8       (mixed)         Google
    --------------------------------------------------------------------

`x-utf8-e4u-unicode' encodes the Unicode 6.0 emojis.

`x-utf8-e4u-google' does NO translations and exists only for useful.

`x-utf8-e4u-mixed' accepts all emojis of three mobile carriers mixed.
On decoding, however, KDDI(app) emojis would be broken as they have conflicts
with SoftBank emojis. So DO NOT use KDDI(app) with this.
On encoding, this replaces Google emojis to others definitively.
This encoding is friendly for the Encode::JP::Mobile manpage and MySQL 5.4.
Note that MySQL before 5.5.3 does not support four bytes UTF-8 including
both Google and Unicode Standard emojis.

Tha last group rejects any emojis above.
You would use these encodings with the Encode::JP::Emoji::FB_EMOJI_TEXT manpage fallback functions.

    Name                        Encoding
    --------------------------------------------------------------------
    x-sjis-emoji-none           Shift_JIS
    x-utf8-emoji-none           UTF-8
    x-sjis-e4u-none             Shift_JIS
    x-utf8-e4u-none             UTF-8
    --------------------------------------------------------------------


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README COPYING
%perl_vendor_privlib/E*

%changelog
