# BEGIN SourceDeps(oneline):
BuildRequires: perl(Encode.pm) perl(Encode/Encoding.pm) perl(ExtUtils/MakeMaker.pm) perl(Getopt/Long/Descriptive.pm) perl(Module/Build.pm) perl(Parse/Lex.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.05
%define module_name Encode-Safename
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: An encoding for safe filenames.
Group: Development/Perl
License: lgpl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BA/BATLOCK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
A filename is encoded as follows:

=over 4

=item *

A range of uppercase characters is changed to lowercase characters,
and put between braces.

    'F'   -> '{F}'
    'FOO' -> '{foo}'

=item *

A range of spaces is changed to underscores.

    ' '   -> '_'
    '   ' -> '___'

=item *

A range of safe characters (characters that are valid on all filesystems,
excluding braces, parentheses, and underscores) is left unchanged.

    'f'   -> 'f'
    'foo' -> 'foo'

=item *

All other characters are changed to their Unicode codepoint in hexadecimal
notation, and put between parentheses.

    ':'  -> '(3a)'
    ':?' -> '(3a)(3f)'

=back

Combined, this gives the following:

    'FOO: Bar Baz.txt' -> '{foo}(3a)_{b}ar_{b}az.txt'

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build --install_path bindoc=%_man1dir

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/E*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
