%define module_name Encode-Unicode-PerlDecodeJava
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Module/Build.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 20171127
Release: alt1
Summary: Encode a Unicode string in Perl and decode it in Java
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PR/PRBRENAN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
encode93($input)

encodes any Perl string given as $input, even one containing Unicode
characters, using only the 93 well known ASCII characters below:

 abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ
 0123456789 '()[]{}<>`!@#$%%^&*_-+=,;:|.?\

and returns the resulting encoded string.

Such a string can be easily compressed and transported using software
restricted to ASCII data and then reconstituted as a Unicode string in Perl by
using decode93() or in Java by using the code reproduced further below.

 decode93($input)

takes an $input string encoded by encode93() and returns the decoded string.

The following Java code takes a string encoded by encode93() and returns the
decoded string to Java:

  String decode93(String input)                                                 // Decode string encoded by encode93()
   {final StringBuilder s = new StringBuilder();
    final StringBuilder n = new StringBuilder();
    final int           N = input.length();

    for(int i = 0; i < N; ++i)                                                  // Decode each character
     {char c = input.charAt(i);
      if (Character.isDigit(c)) n.append(c);                                    // Digit to accumulate
      else if (c == '~')                                                        // Decode number
       {final int p = Integer.parseInt(n.toString());
        s.appendCodePoint(p);
        n.setLength(0);
       }
      else                                                                      // Letter
       {if (n.length() > 0)                                                     // Number available for decode
         {final int p = Integer.parseInt(n.toString());
          s.appendCodePoint(p);
          n.setLength(0);
         }
        s.append(c);                                                            // Add letter
       }
     }
    if (n.length() > 0)                                                         // Trailing number available for decode
     {final int p = Integer.parseInt(n.toString());
  ...
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%perl_vendor_privlib/E*

%changelog
