# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(Module/Build.pm) perl(Module/Signature.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Test/More.pm) perl(base.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name Enumeration
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Yet Another enumeration class implementation.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/R/RO/ROODE/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module provides an enumeration class for Perl.  For those of you
who are not familiar with this concept from other languages, an
enumeration is a class whose instantiated objects may only be assigned
values that come from a fixed list.

There are two ways of using this module.  Typically, you will create a
subclass that inherits from `Enumeration' and which specifies the
list of allowable values.  This is very simple.  Your class module
will contain only three lines of code:

 # MyEnumeration.pm
 #
 package MyEnumeration;
 use base 'Enumeration';
 __PACKAGE__->set_enumerations( qw(red yellow blue green) );

Programs will use this class as follows:

 # some_program.pl
 #
 use MyEnumeration;
 # ....
 my $var = new MyEnumeration(MyEnumeration::yellow);
 # or just: $var = new MyEnumeration;

Users of your subclass may choose to have all of your enumeration
symbols imported into their namespace.  They do this by using the
string `':all'' on the `use' line:

 use MyEnumeration ':all';
 # ....
 my $var = new MyEnumeration(yellow);

The other way to use this module is for when you need an ad-hoc
enumeration at run-time:

 # some_program.pl
 #
 my $var = new Enumeration qw(whee this is fun);



%prep
%setup -n %module_name-%module_version
rm -f t/0-signature.t

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/E*

%changelog
