%define module_name Env-Assert
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(English.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Getopt/Long.pm) perl(Pod/Usage.pm) perl(Test2/V0.pm) perl(constant.pm) perl(open.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.010
Release: alt1
Summary: Ensure that the environment variables match what you need, or abort.
Group: Development/Perl
License: perl
URL: https://metacpan.org/dist/Env-Assert

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MI/MIKKOI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Env::Assert qw( assert );

    my %%want = (
        options => {
            exact => 1,
        },
        variables => {
            USER => { regexp => '^[[:word:]]{1}$', required => 1 },
        },
    );
    my %%parameters;
    $parameters{'break_at_first_error'} = 1;
    my $r = assert( \%%ENV, $desc, \%%parameters );
    if( ! $r->{'success'} ) {
        say report_errors( $r->{'errors'} );
    }

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/E*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
