%define module_name Env-Dot
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Cwd.pm) perl(English.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Path.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(Getopt/Long.pm) perl(IO/File.pm) perl(Pod/Usage.pm) perl(Test/Script.pm) perl(Test2/Require.pm) perl(Test2/V0.pm) perl(base.pm) perl(constant.pm) perl(lib.pm) perl(open.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.018
Release: alt1
Summary: Read environment variables from .env file
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Env-Dot

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MI/MIKKOI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
More flexibility in how you manage and use your .env file.

Features:

=over 8

=item If no .env file is present, then do nothing

By default, Env::Dot will do nothing if there is no
.env file.
You can also configure Env::Dot to emit an alarm
or break execution, if you want.

=item Specify the other dotenv files with path

If your .env file is located in another path,
not the current working directory,
you can use the environment variable
DOTENV_FILEPATHS to tell where your dotenv file is located.
You can specify several file paths; just separate
them by :. Dot::Env will load all the files in the order
you specify them.

=item Support different types of .env files

Unix Shell *source* command compatible dotenv files use quotation marks
(") to define a variable which has spaces. But, for instance,
Docker compatible .env files do not use spaces. The variable
content begins with letter = and ends with linefeed.

You can specify in the dotenv file itself - by using meta commands -
which type of file it is.

=item Use executable envdot to bring the variables into your shell

The executable is distributed together with Dot::Env package in directory *script*.

    eval "$(envdot)"

=back

=for stopwords dotenv env envdot

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

###=for stopwords env dotenv dotenv env envdot

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE-GPL-3 CONTRIBUTING.md SECURITY.md README CODE_OF_CONDUCT.md Changes LICENSE-Artistic-2.0
%perl_vendor_privlib/E*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
