# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec/Functions.pm) perl(File/Temp.pm) perl(Shell/GetEnv.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Env-Modify
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: affect Perl % ENV from subshell
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MO/MOB/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
New Perl programmers are often confused about how the `system' call
interacts with the environment, and they wonder why this code:

    system('export foo=bar');
    system('echo $foo');

behaves differently from

    system('export foo=bar; echo $foo');

or why when they run this code

    system("chdir \$HOME/scripts");
    system("source my.env");
    system("./my_script.sh");

all the environment variables that they carefully set in `my.env' 
are ignored by `./my_script.sh'.

The reason these codes do not meet the new user's expectations
is that subshells, such as those launched by `system', receive
their own copy of the operating system environment and can only
make changes to that local environment.

This module seeks to overcome that limitation, allowing 
`system' calls (and `qx()'/`readpipe'/backticks) calls
to affect the local environment. It uses the clever mechanism
in Diab Jerius's Shell::GetEnv module to copy
the environment of the subshell back to the calling environment.
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/E*

%changelog
