%define module_name Excel-Grinder
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Excel/Writer/XLSX.pm) perl(Module/Build/Tiny.pm) perl(Spreadsheet/XLSX.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.2
Release: alt1
Summary: Import/export plain Excel (XLSX) files as simply as possible.
Group: Development/Perl
License: mit
URL: https://github.com/ericschernoff/Excel-Grinder

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/EC/ECHERNOF/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
/ PURPOSE

This module should help you read/write XLSX spreadsheets to/from Perl arrays 
as simply as possible. The use cases are (1) when you need to export data from 
your database/application for non-programmers to enjoy in their beloved Excel 
and (2) when you need to allow for batch import/update operations via 
user-provided Excel.

There are so many awesome things you can do with Excel (formatting, formulas, 
pivot tables, etc.) but this module does none of that.  This is for the basic 
read-it-in and write-it-out -- which might just fit the bill.

This module will read an Excel (XLSX) file into a three-level arrayref.  The first
level is the worksheets, second level is the rows, and third level is the cells, such that:

_$$my_data[4][2][10] --> Worksheet 5, Row 3, Column 11 (aka as Column K)
_
Form a three-level arrayref to represent worksheets/rows/cells in this way, and you can create
a plain Excel XLSX file.  No formatting or formulas.  Ready for Tableau or just to confuse
your favorite front-line manager.

I put this together because I was offended at how difficult it is just to create an Excel
file in certain non-Perl environments, and since Excel is just a part of life for so many of us,
it really should be dead-simple.

To pursue additional Excel features, please see the excellent the Excel::Writer::XLSX manpage and 
the Spreadsheet::XLSX manpage modules, of which this module is just a simple abstraction.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md
%perl_vendor_privlib/E*

%changelog
