# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Module/Runtime.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Excel-Template-Plus
%define upstream_version 0.06

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_6

Summary:    Testing module for use with Excel::Template::Plus
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Excel/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Excel/Template.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(FindBin.pm)
BuildRequires: perl(IO/String.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(MooseX/Param.pm)
BuildRequires: perl(Spreadsheet/ParseExcel.pm)
BuildRequires: perl(Template.pm)
BuildRequires: perl(Test/Deep.pm)
BuildRequires: perl(Test/Exception.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Module/Build/Compat.pm)
BuildArch: noarch
Source44: import.info


%description
This module is an extension of the Excel::Template module, which allows the
user to use various "engines" from which you can create Excel files through
Excel::Template.

The idea is to use the existing (and very solid) excel file generation code
in Excel::Template, but to extend its more templatey bits with more
powerful options.

The only engine currently provided is the Template Toolkit engine, which
replaces Excel::Template's built in template features (the LOOP, and IF
constructs) with the full power of TT. This is similar to the module
Excel::Template::TT, but expands on that even further to try and create a
more extensive system.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc ChangeLog META.yml README
%perl_vendor_privlib/*

%changelog
