Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Class/Throwable.pm) perl(Error.pm) perl(Exception/Class.pm) perl(Exception/Class/TryCatch.pm) perl(Module/Build.pm) perl(Test/Unit/TestCase.pm) perl(Try/Tiny.pm) perl(TryCatch.pm) perl(experimental.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Exception-Base
Version:        0.2501
Release:        alt2_27
Summary:        Lightweight exceptions
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Exception-Base
Source0:        https://cpan.metacpan.org/modules/by-module/Exception/Exception-Base-%{version}.tar.gz
Source2:        to_string_changes_errors.t
Patch0:         Exception-Base-0.2501-smartmatch.patch
BuildArch:      noarch
# Module Build
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Module Runtime
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(overload.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Symbol.pm)
BuildRequires:  perl(warnings.pm)
# Test Suite
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(File/Basename.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(if.pm)
BuildRequires:  perl(Test/Unit/Lite.pm)
# Test for https://bugzilla.redhat.com/show_bug.cgi?id=1273668
BuildRequires:  perl(Storable.pm)
BuildRequires:  perl(Test/More.pm)
# Dependencies
Requires:       perl(Scalar/Util.pm)
Requires:       perl(Symbol.pm)
Source44: import.info

%description
This class implements a fully OO exception mechanism similar to
Exception::Class or Class::Throwable. It provides a simple interface
allowing programmers to declare exception classes. These classes can be
thrown and caught. Each uncaught exception prints full stack trace if the
default verbosity is increased for debugging purposes.

%prep
%setup -q -n Exception-Base-%{version}

# Fix FTBFS with Perl 5.38 onwards (rhbz#2222742)
# Smartmatch is deprecated, resulting warning causes test failures
# https://github.com/dex4er/perl-Exception-Base/issues/5
%patch0 

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -delete
# %{_fixperms} -c %{buildroot}

%check
make test

# to_string() appends 'undef' to array attribute
# https://bugzilla.redhat.com/show_bug.cgi?id=1273668
# https://github.com/dex4er/perl-Exception-Base/issues/3
# Fixed in 0.2501
make test TEST_FILES=%{SOURCE2}

%files
%doc --no-dereference LICENSE
%doc Changes Incompatibilities README examples/
%{perl_vendor_privlib}/Exception/

%changelog
