Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-ExtUtils-MakeMaker-Coverage
Version:        0.05
Release:        alt2_48
Summary:        Allows perl modules to check test coverage with Devel::Cover

License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            http://backpan.perl.org/authors/id/S/SM/SMPETERS/
Source0:        http://backpan.perl.org/authors/id/S/SM/SMPETERS/ExtUtils-MakeMaker-Coverage-%{version}.tar.gz

BuildArch:      noarch

BuildRequires:  coreutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Devel/Cover.pm)
BuildRequires:  perl(Object/Accessor.pm)
# Tests
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
Requires:       perl(Devel/Cover.pm)
Source44: import.info

%description
This module adds an additional target to the Makefile generated by
ExtUtils::MakeMaker. The target, testcover, calls cover, the
command-line script to generate test coverage statistics, to clean up
any data from a previous run. It then runs the tests, as if make test
was run, then calls cover again to generate the coverage statistics.


%prep
%setup -q -n ExtUtils-MakeMaker-Coverage-%{version}


%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build


%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
chmod -R u+w $RPM_BUILD_ROOT/*


%check
make test


%files
%doc Changes README
%{perl_vendor_privlib}/ExtUtils/MakeMaker/Coverage.pm
%{_bindir}/testcover

%changelog
