%define module_name FASTX-Reader
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Capture/Tiny.pm) perl(Carp.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Fetch.pm) perl(File/Which.pm) perl(FindBin.pm) perl(IO/Uncompress/Gunzip.pm) perl(JSON/PP.pm) perl(PerlIO/encoding.pm) perl(Pod/Usage.pm) perl(Term/ANSIColor.pm) perl(Text/ASCIITable.pm) perl(Time/HiRes.pm) perl(autodie.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.12.0
Release: alt1
Summary: A lightweight FASTA and FASTQ reader based on Heng Li's parser.
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PR/PROCH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use FASTX::Reader;
  my $filepath = '/path/to/assembly.fastq';
  die "Input file not found: $filepath\n" unless (-e "$filepath");
  my $fasta_reader = FASTX::Reader->new({ filename => "$filepath" });

  while (my $seq = $fasta_reader->getRead() ) {
    print $seq->{name}, "\t", $seq->{seq}, "\t", $seq->{qual}, "\n";
  }

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md README Changes CONTRIBUTING.md
%perl_vendor_privlib/F*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
