%define module_name FCGI-Buffer
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI/Info.pm) perl(CGI/Lingua.pm) perl(CHI.pm) perl(CSS/Packer.pm) perl(Capture/Tiny.pm) perl(Carp.pm) perl(Compress/Zlib.pm) perl(Compress/Zstd.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(DateTime.pm) perl(DateTime/Format/HTTP.pm) perl(Digest/MD5.pm) perl(Directory/Scratch.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Path.pm) perl(File/Spec.pm) perl(HTML/Clean.pm) perl(HTML/Lint.pm) perl(HTML/Packer.pm) perl(HTTP/Date.pm) perl(HTTP/Headers.pm) perl(HTTP/Response.pm) perl(HTTP/Status.pm) perl(I18N/AcceptLanguage.pm) perl(I18N/LangTags/Detect.pm) perl(IO/String.pm) perl(IPC/System/Simple.pm) perl(JavaScript/Packer.pm) perl(LWP/ConnCache.pm) perl(LWP/UserAgent.pm) perl(Locale/Language.pm) perl(Locale/Object/Country.pm)
BuildRequires: perl(Readonly.pm) perl(Storable.pm) perl(Test/DescribeMe.pm) perl(Test/Most.pm) perl(Test/Needs.pm) perl(Test/NoWarnings.pm) perl(Text/Diff.pm) perl(Time/localtime.pm) perl(autodie.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.21
Release: alt1
Summary: Verify and Optimise FCGI Output
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NH/NHORNE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
FCGI::Buffer verifies the HTML that you produce by passing it through
`HTML::Lint'.

FCGI::Buffer optimises FCGI programs by compressing output to speed up
the transmission and by nearly seamlessly making use of client and
server caches.

To make use of client caches, that is to say to reduce needless calls
to your server asking for the same data:

    use FCGI;
    use FCGI::Buffer;
    # ...
    my $request = FCGI::Request();
    while($request->FCGI::Accept() >= 0) {
        my $buffer = FCGI::Buffer->new();
        $buffer->init(
                optimise_content => 1,
                lint_content => 0,
        );
_# ...
    }

To also make use of server caches, that is to say to save regenerating
output when different clients ask you for the same data, you will need
to create a cache.
But that's simple:

    use FCGI;
    use CHI;
    use FCGI::Buffer;

    # ...
    my $request = FCGI::Request();
    while($request->FCGI::Accept() >= 0) {
        my $buffer = FCGI::Buffer->new();
        $buffer->init(
_    optimise_content => 1,
_    lint_content => 0,
_    cache => CHI->new(driver => 'File')
        );
_if($buffer->is_cached()) {
_    # Nothing has changed - use the version in the cache
_    $request->Finish();
_    next;
_# ...
    }

If you get errors about Wide characters in print it means that you've
forgotten to emit pure HTML on non-ascii characters.
See the HTML::Entities manpage.
As a hack work around you could also remove accents and the like by using
the Text::Unidecode manpage,
which works well but isn't really what you want.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README README.md ignore.txt
%perl_vendor_privlib/F*

%changelog
