%define module_name FCGI-EV-Std
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI/Stateless.pm) perl(Module/Build/Tiny.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.0.1
Release: alt1
Summary: Handler class to use with FCGI::EV
Group: Development/Perl
License: mit
URL: https://github.com/powerman/perl-FCGI-EV-Std

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PO/POWERMAN/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This module must be used together with FCGI::EV. It will handle CGI.requests received by FCGI::EV. Both blocking and non-blocking CGI request
handling supported.

It will validate size of STDIN: do not accept size larger than configured
in $MAX_STDIN (1 MB by default), do not accept incomplete STDIN (less
than $ENV{CONTENT_LENGTH} bytes) - in both cases HTTP reply "417
Expectation Failed" will be returned to browser.

In non-blocking mode it optionally may call user callback function if web
server disconnect before CGI sent it reply (to interrupt processing this
request, if possible).

It compatible with CGI.pm (CGI.pm must be loaded before FCGI::EV::Std
to activate this feature, and you'll need CGI::Stateless module), but may
also work with other modules which parse CGI parameters - in this case
these modules must support work in persistent environment and user
probably has to re-initialize that module state between requests.



%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/F*

%changelog
