# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(YAML/Tiny.pm) perl(base.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    FCGI-ProcManager-MaxRequests
%define upstream_version 0.02

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_13

Summary:    Restrict max number of requests by each child
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/FCGI/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(FCGI/ProcManager.pm)
BuildRequires: perl(inc/Module/Install.pm)
BuildRequires: perl(Test/More.pm)
BuildArch: noarch
Source44: import.info


%description
FCGI-ProcManager-MaxRequests is a extension of FCGI-ProcManager that allow
restrict fastcgi processes to process only limiting number of requests.
This may help avoid growing memory usage and compensate memory leaks.

This module subclass the FCGI::ProcManager manpage. After server process
max_requests number of requests, it simple exit, and manager starts another
server process. Maximum number of requests can be set from PM_MAX_REQUESTS
environment variable, max_requests - constructor argument and max_requests
accessor.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc META.yml Changes README
%perl_vendor_privlib/*


%changelog
