%define module_name FFI-C-Stat
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(FFI/Build/MM.pm) perl(FFI/Platypus.pm) perl(File/chdir.pm) perl(Path/Tiny.pm) perl(Ref/Util.pm) perl(Test/Script.pm) perl(Test2/V0.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Object-oriented FFI interface to native stat and lstat
Group: Development/Perl
License: perl
URL: https://metacpan.org/pod/FFI::C::Stat

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PL/PLICEASE/%{module_name}-%{version}.tar.gz

%description
Perl comes with perfectly good `stat', `lstat' functions, however if you are writing
FFI bindings for a library that use the C `stat' structure, you are out of luck there.
This module provides an FFI friendly interface to the C `stat' function, which uses
an object similar to the File::stat manpage, except the internals are a real C `struct' that
you can pass into C APIs that need it.

Supposing you have a C function:

 void
 my_cfunction(struct stat *s)
 {
   ...
 }

You can bind `my_cfunction' like this:

 use FFI::Platypus 1.00;
 
 my $ffi = FFI::Platypus->new( api => 1 );
 $ffi->type('object(FFI::C::Stat)' => 'stat');
 $ffi->attach( my_cfunction => ['stat'] => 'void' );

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc author.yml Changes README LICENSE examples
%perl_vendor_archlib/auto/*
%perl_vendor_archlib/F*
%changelog
