# BEGIN SourceDeps(oneline):
BuildRequires: perl(Error/Helper.pm) perl(Mojo/IOLoop/ReadWriteFork.pm) perl(Mojolicious/Lite.pm) perl(String/ShellQuote.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.1.1
%define module_name FFmpeg-Stream-Helper
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.1
Release: alt1
Summary: Helper for streaming and transcoding using ffmpeg.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VV/VVELOX/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module is for helping generate a command for ffmpeg that should be good for streaming to HTML5.

This module also does it securely by using String::ShellQuote for every definable option passed to ffmpeg.

    # Defaults Are...
    # Output: -  ((standard out))
    # Bit Rate: 2000 kbps
    # Bound: undef
    # Format: mp4
    # Log Level: quiet
    # Threads: 0
    my $fsh=FFmpeg::Stream::Helper->new;

    #sets the bit rate to 1500
    $fsh->bitRateSet('1500');
    if ( $fsh->error ){
        warn('error:'.$fsh->error.': '.$fsh->errorString);
    }

    # Enable printing of errors.
    $fsh->loglevelSet('error');
    if ( $fsh->error ){
        warn('error:'.$fsh->error.': '.$fsh->errorString);
    }

    # set the width bound to 800 for scaling
    # aspect will be kept
    $fsh->boundSet('800');
    if ( $fsh->error ){
        warn('error:'.$fsh->error.': '.$fsh->errorString);
    }    

    # Disable pretty much all error output. This is great if you are sending stuff
    # to STDOUT and what you are sending it to can't tell the difference between it
    # and STDERR
    $fsh->loglevelSet('quiet');
    if ( $fsh->error ){
        warn('error:'.$fsh->error.': '.$fsh->errorString);
    }

    # What? No. We can't stop here. This is bat country.
    my $command=$fsh->command('/arc/video/movies/Fear and Loathing in Las Vegas.avi');
    if ( $fsh->error ){
        warn('error:'.$fsh->error.': '.$fsh->errorString);
    }
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes example
%perl_vendor_privlib/F*

%changelog
