# BEGIN SourceDeps(oneline):
BuildRequires: perl(Authen/SASL.pm) perl(ExtUtils/MakeMaker.pm) perl(MIME/Base64.pm) perl(MIME/Lite.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name FWS-V2-SocketLabs
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: FrameWork Sites version 2 socketlabs.com SMTP integration
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/N/NA/NATELEWIS/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module will process all outgoing mail from FWS 2.0 though a socketlabs.com SMTP account.   Add the following to your FWS go.pl FWS parameter:

	
	my $fws = FWS::V2->new( %%yourConfiguration,
				sendMethod		=> 'socketlabs');

Here is an example FWS independent process you can use as a starter to make your own customized FWS socketlabs process.   This will be appropriate to be added to your CRONTAB to run 'socketLabs.pl send' every minute and run 'socketLabs.pl audit' every hour.   This will work fine if your sending less than 500 email an hour.   If you are sending more than that you should create a custom optimized script for your application based on what your trying to accomplish.

Crontab entry:

	* * * * * /wherever/it/is/socketLabs.pl send  >/dev/null 2>&1
	0 * * * * /wherever/it/is/socketLabs.pl audit  >/dev/null 2>&1

socketLabs.pl:

	#!/usr/bin/perl
	use strict;

	#
	# setup your FWS
	#
	use FWS::V2;

	my $fws = FWS::V2->new(%%yourConfiguration,
       		                        
			SocketLabs=>{	mailingId       => 'unique',  # up to 8 characters of unique string
       		                        port            => '2525',
               		                host            => 'smtp.socketlabs.com',
                       		        username        => 'user name for SMTP auth',
                               		password        => 'password for SMTP auth',
		                        queueFailLimit  => 5,
               		                apiURL          => 'https://api.socketlabs.com/v1',
                       		        apiAccountId    => 'from socket labs account',
	                     		apiPassword     => 'from socket labs account',
       					apiUsername     => 'from socket labs account'}
			);

	#
	# add SocketLabs
	#
	$fws->registerPlugin('FWS::V2::SocketLabs');

	#
	# Add your site values
	#
	$fws->setSiteValues('site');


	#
	# Usage String
	#
	my $usageString = "\nUsage: socketlabs.pl [send|audit]\n\n\tsend: send the current queue\n\taudit: sync the socketlabs data with FWS\n\n";
	if ($#ARGV != 0) { print $usageString }

	#
	# we have an argument lets do it!
	#
	else {
        	
		my $arg = $ARGV[0];
        	my $email = $ARGV[1];
	

		#
		# send anything in the queue
		#	
	        if ($arg eq 'send') {
	                print "Runnning Process: ".$arg."\n\n";
	                $fws->SocketLabs_processQueue();
                }

		#
		# audit anything that was sent and update FWS if there is something not synced
		#
        	elsif ($arg eq 'audit') {
               		print "Runnning Process: ".$arg."\n\n";
                	my @historyArray = $fws->queueHistoryArray(synced=>'0');
                	if ($#historyArray > -1 ) { $fws->SocketLabs_processAudit() }
                	else { print "No sync required\n\n" }
        	}
	}
	1;



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/F*

%changelog
