Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Fedora-VSP
Version:        0.001
Release:        alt2_34
Summary:        Perl version normalization for RPM
License:        GPL-3.0-or-later
URL:            https://ppisar.fedorapeople.org/Fedora-VSP/
Source0:        https://ppisar.fedorapeople.org/Fedora-VSP/Fedora-VSP-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  findutils
BuildRequires:  perl-devel
%if %{defined perl_bootstrap}
BuildRequires:  perl-macros
%else
# Break build cycle: perl-Fedora-VSP a.. perl-generators a.. perl-Fedora-VSP
BuildRequires:  rpm-build-perl
%endif
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Run-time:
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Tests:
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(version.pm)
%if %{defined perl_bootstrap}
# Break build cycle: perl-Fedora-VSP a.. perl-generators a.. perl-Fedora-VSP
Requires:       perl(strict.pm)
Requires:       perl(warnings.pm)
Provides:       perl(Fedora/VSP.pm) = %{version}
%endif
Source44: import.info

%description
This module provides functions for normalizing Perl version strings for
Red Hat Package (RPM) based Linux distributions.

%package tests
Group: Development/Other
Summary:        Tests for %{name}
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n Fedora-VSP-%{version}
# Help generators to recognize Perl scripts
for F in $(find t/ -name '*.t'); do
    perl -i -MConfig -ple 'print $Config{startperl} if $. == 1 && !s{\A#!\s*perl}{$Config{startperl}}' "$F"
    chmod +x "$F"
done

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# Install tests
mkdir -p %{buildroot}%{_libexecdir}/%{name}
cp -a t %{buildroot}%{_libexecdir}/%{name}
cat > %{buildroot}%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/sh
cd %{_libexecdir}/%{name} && exec prove -I . -j "$(getconf _NPROCESSORS_ONLN)" -r
EOF
chmod +x %{buildroot}%{_libexecdir}/%{name}/test
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc --no-dereference COPYING
%{perl_vendor_privlib}/*

%files tests
%{_libexecdir}/%{name}

%changelog
