# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    File-AtomicWrite
%define upstream_version 1.21

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_3

Summary:    Writes files atomically via rename()
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/File/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(Digest/SHA1.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Path.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(IO/Handle.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(lib.pm)
BuildRequires: perl(strict.pm)
BuildArch:  noarch
Source44: import.info

%description
This module offers atomic file writes via a temporary file created in the
same directory (and therefore, probably the same partition) as the
specified *file*. After data has been written to the temporary file, the
'rename' call is used to replace the target *file*. The module optionally
supports various sanity checks (*min_size*, *CHECKSUM*) that help ensure
the data is written without errors.

Should anything go awry, the module will 'die' or 'croak'. All calls should
be wrapped in eval blocks:

  eval {
    File::AtomicWrite->write_file(...);
  };
  if ($@) {
    die "uh oh: $@";
  }

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README SIGNATURE eg
%{perl_vendor_privlib}/*

%changelog
