%def_without test
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(DynaLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_version 0.94
%define module_name File-BSDGlob
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.94
Release: alt7
Summary: Perl extension for BSD glob routine
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/G/GB/GBACON/%module_name-%module_version.tar.gz

%description
File::BSDGlob implements the FreeBSD glob(3) routine, which is a superset
of the POSIX glob() (described in IEEE Std 1003.2 "POSIX.2").  The
glob() routine takes a mandatory `pattern' argument, and an optional
`flags' argument, and returns a list of filenames matching the
pattern, with interpretation of the pattern modified by the `flags'
variable.  The POSIX defined flags are:

=over 4

=item `GLOB_ERR'

Force glob() to return an error when it encounters a directory it
cannot open or read.  Ordinarily glob() continues to find matches.

=item `GLOB_MARK'

Each pathname that is a directory that matches the pattern has a slash
appended.

=item `GLOB_NOCHECK'

If the pattern does not match any pathname, then glob() returns a list
consisting of only the pattern.  If `GLOB_QUOTE' is set, its effect
is present in the pattern returned.

=item `GLOB_NOSORT'

By default, the pathnames are sorted in ascending ASCII order; this
flag prevents that sorting (speeding up glob()).

=back

The FreeBSD extensions to the POSIX standard are the following flags:

=over 4

=item `GLOB_BRACE'

Pre-process the string to expand `{pat,pat,...} strings like csh(1).
The pattern '{}' is left unexpanded for historical reasons (and csh(1)
does the same thing to ease typing of find(1) patterns).

=item `GLOB_NOMAGIC'

Same as `GLOB_NOCHECK' but it only returns the pattern if it does not
contain any of the special characters "*", "?" or "[".  `NOMAGIC' is
provided to simplify implementing the historic csh(1) globbing
behaviour and should probably not be used anywhere else.

=item `GLOB_QUOTE'

Use the backslash ('\') character for quoting: every occurrence of a
backslash followed by a character in the pattern is replaced by that
character, avoiding any special interpretation of the character.

=item `GLOB_TILDE'

Expand patterns that start with '~' to user name home directories.

=item `GLOB_CSH'

For convenience, `GLOB_CSH' is a synonym for
`GLOB_BRACE | GLOB_NOMAGIC | GLOB_QUOTE | GLOB_TILDE'.

=back

The POSIX provided `GLOB_APPEND', `GLOB_DOOFFS', and the FreeBSD
extensions `GLOB_ALTDIRFUNC', and `GLOB_MAGCHAR' flags have not been
implemented in the Perl version because they involve more complex
interaction with the underlying C structures.

'
%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes TODO
%perl_vendor_archlib/F*
%perl_vendor_autolib/*

%changelog
