# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Config.pm) perl(Fcntl.pm) perl(Symbol.pm) perl(overload.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    File-CounterFile
%define upstream_version 1.04

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_10

Summary:    Persistent counter class
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/File/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildArch: noarch
Source44: import.info

%description
This module implements a persistent counter class. Each counter is
represented by a separate file in the file system. File locking is applied,
so multiple processes can attempt to access a counter simultaneously
without risk of counter destruction.

You give the file name as the first parameter to the object constructor
('new'). The file is created if it does not exist.

If the file name does not start with "/" or ".", then it is interpreted as
a file relative to '$File::CounterFile::DEFAULT_DIR'. The default value for
this variable is initialized from the environment variable 'TMPDIR', or
_/usr/tmp_ if no environment variable is defined. You may want to assign a
different value to this variable before creating counters.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc README Changes
%perl_vendor_privlib/*




%changelog
