%define module_name File-IsSorted
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/Cmd/Setup.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Moo.pm) perl(Path/Tiny.pm) perl(Test/Builder/Module.pm) perl(Test/More.pm) perl(Test/Run/CmdLine/Iface.pm) perl(Test/Tester.pm) perl(autodie.pm) perl(locale.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.2.0
Release: alt1
Summary: check if the lines of a file are sorted lexicographically
Group: Development/Perl
License: mit
URL: http://metacpan.org/release/File-IsSorted

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SH/SHLOMIF/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This checks if the lines of files or filehandles are monotonically and lexicographically
increasing, (= are already sorted). It may consume less RAM and be faster than the
naive way of doing `cmp myfile.txt <(LC_ALL=C sort myfile.txt)' and it runs at
O(n) instead of O(n*log(n)) time and keeps O(1) lines instead of O(n).

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/F*
%perl_vendor_privlib/T*
%perl_vendor_privlib/A*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
