%define module_name File-Locate-Iterator
# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(Devel/TimeThis.pm) perl(ExtUtils/MakeMaker.pm) perl(File/FnMatch.pm) perl(File/Map.pm) perl(HTML/Entities.pm) perl(IO/String.pm) perl(IPC/Run.pm) perl(Iterator.pm) perl(Iterator/Simple.pm) perl(Moose.pm) perl(Moose/Util/TypeConstraints.pm) perl(MooseX/Iterator/Array.pm) perl(MooseX/Iterator/Hash.pm) perl(MooseX/Iterator/Meta/Iterable.pm) perl(MooseX/Iterator/Role.pm) perl(Perl6/Slurp.pm) perl(PerlIO/Layers.pm) perl(PerlIO/via/Base64.pm) perl(Pod/Simple/HTML.pm) perl(Scalar/Util.pm) perl(Smart/Comments.pm) perl(Sys/Mmap.pm) perl(Taint/Util.pm) perl(Test/More.pm) perl(Text/Glob.pm) perl(constant/defer.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 28
Release: alt4
Summary: Read "locate" database file with an iterator.
Group: Development/Perl
License: gpl
URL: http://user42.tuxfamily.org/file-locate-iterator/index.html

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KR/KRYDE/%{module_name}-%{version}.tar.gz

%description
`File::Locate::Iterator' reads a "locate" database file in iterator style.
Each `next()' call on the iterator returns the next entry from the
database.

    /
    /bin
    /bin/bash
    /bin/cat

Locate databases normally hold filenames as a way of finding files by name
faster than searching through all directories.  Optional glob, suffix and
regexp options on the iterator can restrict the entries returned.

See examples/native.pl in the File-Locate-Iterator sources for a simple
sample read, or examples/mini-locate.pl for a whole locate program
simulation.

Only "LOCATE02" format files are supported, as per current versions of GNU
`locate', not the previous "slocate" format.

Iterators from this module are stand-alone, they don't need any of the
various Perl iterator frameworks.  But see the Iterator::Locate manpage,
the Iterator::Simple::Locate manpage and the MooseX::Iterator::Locate manpage to inter-operate
with those frameworks.  Those frameworks include ways to grep, map and
otherwise manipulate iterations.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README COPYING examples
%perl_vendor_archlib/F*
%perl_vendor_archlib/M*
%perl_vendor_archlib/I*
%perl_vendor_autolib/*

%changelog
