%define module_version 1.02
%define module_name File-Lock-Multi
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Class/Accessor.pm) perl(Config.pm) perl(DBD/mysql.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Temp.pm) perl(Linux/Fuser.pm) perl(Params/Classify.pm) perl(Params/Validate.pm) perl(Test/Exception.pm) perl(Test/Fork.pm) perl(Test/More.pm) perl(Time/HiRes.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.02
Release: alt1
Summary: Lock files more than once
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/C/CR/CRAKRJACK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
flock() (and co-operative locks in general) are a handy
tool used for various synchronization tasks;

=over

=item ensuring a daemon/process may only have one copy running at once

=item "waiting in line" for your turn to write to a file

=item flagging that a certain process, or a certain part of a process is running

=item etc...

=back

POSIX supports the concept of "exclusive" ("write") and "shared" ("read")
locks on files -- many processes may take out a "shared" lock on any
particular file, but only one process may have an "exclusive" lock, and that
process can not take out this lock unless there are no "shared" locks
open.

Part of what makes this such an effective and worry-free system, is that
these locks are maintained on the kernel level -- so if you kill off a
process, you do not need to be concerned that the locks it had will stick
around and get in some other process's way.

... But let's say you have a CPU-intensive operation that you want to limit
to, oh, 5 running copies at a time? Or 3 different types of CPU-intensive
operation that you want to collectively limit to 2 running copies at a time?
You could keep a counter somewhere, but if processes are killed off manually,
what is going to come along and decrement your counter?

"exclusive" locks are just that -- exclusive -- and there is no simple way
to tell how many processes have taken out a "shared" lock on a file (from
perl, anyway).

`File::Lock::Multi' is designed to work around this problem by providing
it's own type of "locks" that behave like POSIX "exclusive" locks, except
that you can specify how many locks are allowed to be taken out. So long
as each process agrees on the maximum number of locks, they can work in
parallel, but within the limits you have specified.

There are three locking mechanisms available; the File::Lock::Multi::Fuser manpage
allows you to have multi-locks using just one file, but only works on linux
and has some drawbacks (see the documentation for details);
the File::Lock::Multi::FlockFiles manpage uses the `flock()' call on several files
named after the file you specify in order to emulate allowing more than one
lock. the File::Lock::Multi::MySQL manpage allows you to use a MySQL backend to
take out multiple locks on a resource that is shared across multiple servers,
using MySQL's GET_LOCK function.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/F*

%changelog
