# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    File-Policy
%define upstream_version 1.005

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_11

Summary:    Simple policy for file I/O functions
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/File/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Slurp.pm)
BuildRequires: perl(File/Spec/Functions.pm)
BuildRequires: perl(Log/Trace.pm)
BuildRequires: perl(Test/Assertions.pm)
BuildArch: noarch
Source44: import.info

%description
This defines the policy for file I/O with modules such as
File::Slurp::WithinPolicy. The purpose is to allow systems administrators
to define locations and restrictions for applications' file I/O and give
app developers a policy to follow. Note that the module doesn't ENFORCE the
policy - application developers can choose to ignore it (and systems
administrators can choose not to install their applications if they do!).

You may control which policy gets applied by creating a
File::Policy::Config module with an IMPLEMENTATION constant. You may write
your own policy as a module within the File::Policy:: namespace.

By default (if no File::Policy::Config is present), the
File::Policy::Default policy gets applied which doesn't impose any
restrictions and provides reasonable default locations for temporary and
log files.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc README META.yml Changes
%perl_vendor_privlib/*




%changelog
