Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:       perl-File-RsyncP
Version:    0.76
Release:    alt4_16
Summary:    A perl implementation of an Rsync client
# https://fedoraproject.org/wiki/Licensing:FAQ?rd=Licensing/FAQ#What_about_the_RSA_license_on_their_MD5_implementation.3F_Isn.27t_that_GPL-incompatible.3F
License:    GPL-2.0-only AND GPL-3.0-only AND ( GPL-1.0-or-later OR Artistic-1.0-Perl )
URL:        https://metacpan.org/release/File-RsyncP
Source0:    https://cpan.metacpan.org/authors/id/C/CB/CBARRATT/File-RsyncP-%{version}.tar.gz
# Adapt a configure check to GCC 12, bug #2046804, CPAN RT#141822
Patch0:     File-RsyncP-0.76-Fix-configure-check-with-optimizing-and-lto-enabled-.patch
Patch1:     perl-File-RsyncP-configure-c99.patch
# Build
BuildRequires: coreutils
BuildRequires: findutils
BuildRequires: gcc
BuildRequires: perl-devel
BuildRequires: rpm-build-perl
BuildRequires: perl-devel
BuildRequires: perl(ExtUtils/MakeMaker.pm)
# Runtime
BuildRequires: perl(AutoLoader.pm)
BuildRequires: perl(Config.pm)
BuildRequires: perl(constant.pm)
BuildRequires: perl(Data/Dumper.pm)
BuildRequires: perl(DynaLoader.pm)
BuildRequires: perl(Encode.pm)
BuildRequires: perl(Exporter.pm)
BuildRequires: perl(Fcntl.pm)
BuildRequires: perl(File/Path.pm)
BuildRequires: perl(Getopt/Long.pm)
BuildRequires: perl(Socket.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(vars.pm)
Source44: import.info
# Tests only
# nothing

%description
File::RsyncP is a perl implementation of an Rsync client. It is compatible with
Rsync 2.5.5 - 2.6.3 (protocol versions 26-28). It can send or receive files,
either by running rsync on the remote machine, or connecting to an rsyncd
daemon on the remote machine.

%prep
%setup -q -n File-RsyncP-%{version}
%patch0 -p1
%patch1 -p1

# Update config.guess/sub to fix builds on new architectures (aarch64/ppc64le)
# cp /usr/lib/rpm/redhat/config.* FileList/

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
make %{?_smp_flags}

%install
%{makeinstall_std}
find %{buildroot} -type f -name '*.bs' -a -size 0 -delete
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc --no-dereference LICENSE
%doc Changes README
%{perl_vendor_archlib}/File/
%{perl_vendor_archlib}/auto/File/

%changelog
