# BEGIN SourceDeps(oneline):
BuildRequires: perl(Archive/Zip.pm) perl(CPAN.pm) perl(Class/Accessor.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(IO/String.pm) perl(Module/Build.pm) perl(Test/More.pm) perl(Time/Piece.pm) perl(Time/Seconds.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define module_version 0.25
%define module_name File-SAUCE
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.25
Release: alt1
Summary: A library to manipulate SAUCE metadata
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BR/BRICAS/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
SAUCE stands for Standard Architecture for Universal Comment Extentions. It is used as metadata
to describe the file to which it is associated. It's most common use has been with the ANSI and
ASCII "art scene."

A file containing a SAUCE record looks like this:

    +----------------+
    | FILE Data      |
    +----------------+
    | EOF Marker     |
    +----------------+
    | SAUCE Comments |
    +----------------+
    | SAUCE Record   |
    +----------------+

The SAUCE Comments block holds up to 255 comment lines, each 64 characters wide. It looks like this:

    +----------------+------+------+---------+-------------+
    | Field          | Size | Type | Default | set / get   |
    +----------------+------+------+---------+-------------+
    | ID             | 5    | Char | COMNT   | commment_id |
    +----------------+------+------+---------+-------------+
    | Comment Line 1 | 64   | Char |         | comments*   |
    +----------------+------+------+---------+-------------+
    | ...                                                  |
    +----------------+------+------+---------+-------------+
    | Comment Line X | 64   | Char |         | comments    |
    +----------------+------+------+---------+-------------+

* Comments are stored as an array ref

And lastly, the SAUCE Record. It is exactly 128 bytes long:

    +----------------+------+------+---------+-------------+
    | Field          | Size | Type | Default | set / get   |
    +----------------+------+------+---------+-------------+
    | ID             | 5    | Char | SAUCE   | sauce_id    |
    +----------------+------+------+---------+-------------+
    | SAUCE Version  | 2    | Char | 00      | version     |
    +----------------+------+------+---------+-------------+
    | Title          | 35   | Char |         | title       |
    +----------------+------+------+---------+-------------+
    | Author         | 20   | Char |         | author      |
    +----------------+------+------+---------+-------------+
    | Group          | 20   | Char |         | group       |
    +----------------+------+------+---------+-------------+
    | Date           | 8    | Char |         | date        |
    +----------------+------+------+---------+-------------+
    | FileSize       | 4    | Long |         | filesize    |
    +----------------+------+------+---------+-------------+
    | DataType       | 1    | Byte |         | datatype_id |
    +----------------+------+------+---------+-------------+
    | FileType       | 1    | Byte |         | filetype_id |
    +----------------+------+------+---------+-------------+
    | TInfo1         | 2    | Word |         | tinfo1      |
    +----------------+------+------+---------+-------------+
    | TInfo2         | 2    | Word |         | tinfo2      |
    +----------------+------+------+---------+-------------+
    | TInfo3         | 2    | Word |         | tinfo3      |
    +----------------+------+------+---------+-------------+
    | TInfo4         | 2    | Word |         | tinfo4      |
    +----------------+------+------+---------+-------------+
    | Comments       | 1    | Byte |         | comments    |
    +----------------+------+------+---------+-------------+
    | Flags          | 1    | Byte |         | flags_id    |
    +----------------+------+------+---------+-------------+
    | Filler         | 22   | Byte |         | filler      |
    +----------------+------+------+---------+-------------+

For more information see ACiD.org's SAUCE page at http://www.acid.org/info/sauce/sauce.htm


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README examples
%perl_vendor_privlib/F*

%changelog
