# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    File-ShareDir-Tarball
%define upstream_version 0.2.2

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_9

Summary:    Deal transparently with shared files distributed as tarballs
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/File/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Archive/Tar.pm)
BuildRequires: perl(Carp.pm)
BuildRequires: perl(Exporter.pm)
BuildRequires: perl(File/Find.pm)
BuildRequires: perl(File/ShareDir.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(File/chdir.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Test/File/ShareDir.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(parent.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
If the shared files of a distribution are contained in a tarball (see the
Dist::Zilla::Plugin::ShareDir::Tarball manpage for why you would want to do
that), automatically extract the archive in a temporary directory and
return the path to that directory. If called for a regular distribution
without a bundle file ('shared-files.tar.gz'), it'll return the original
shared dir. In other words, from the consumer point of view, it'll behave
just like the File::ShareDir manpage.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Build.PL installdirs=vendor

./Build

%check
./Build test

%install
./Build install destdir=%{buildroot}

%files
%doc Changes INSTALL LICENSE META.json META.yml  README SIGNATURE
%perl_vendor_privlib/*

%changelog
