# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    File-Slurp-Remote
%define upstream_version 0.44

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_11

Summary:    Discover canonical hostnames, sometimes with `hostname`
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/File/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Slurp.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(Sys/Hostname/FQDN.pm)
BuildRequires: perl(Tie/Hash.pm)
BuildArch:  noarch
Provides: perl(File/Slurp/Remote.pm)
Source44: import.info

%description
This is similar to the File::Slurp manpage, but it reads and writes files
on remote systems using 'ssh' to get there.

It uses ssh/scp to get to the remote systems. You can override the copy
command by redefining '$File::Slurp::Remote::scp'. You can override the
remote shell command by redefining '$File::Slurp::Remote::SmartOpen::ssh'.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc CHANGELOG META.yml 
%perl_vendor_privlib/*


%changelog
