# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Exporter.pm) perl(Fcntl.pm) perl(IO/File.pm) perl(POSIX.pm) perl(Symbol.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    File-Sort
%define upstream_version 1.01

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_10

Summary:    Sort a file or merge sort multiple files
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/File/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildArch: noarch
Source44: import.info

%description
This module sorts text files by lines (or records). Comparisons are based
on one or more sort keys extracted from each line of input, and are
performed lexicographically. By default, if keys are not given, sort
regards each input line as a single field. The sort is a merge sort. If you
don't like that, feel free to change it.

Options
    The following options are available, and are passed in the hash
    reference passed to the function in the format:

      OPTION => VALUE

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc README
%perl_vendor_privlib/*




%changelog
