# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Time/Local.pm) perl(strict.pm) perl(vars.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name File-SortedSeek-PERLANCAR
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.015.1
Release: alt1
Summary: A fork of File::SortedSeek with some more options
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/File-SortedSeek-PERLANCAR

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module (File::SortedSeek::PERLANCAR) is a fork of the File::SortedSeek manpage
0.015, adding these things:

=over

=item * binsearch() function

Not yet documented, but basically it accepts a comparator function for you to do
custom comparison, much like how the List::BinarySearch manpage allows you to do the same
thing.

Usage:

 binsearch($fh, $value, \&compare [ , \&munge [ , $minoffset, $maxoffset ] ]);

=item * $minoffset & $maxoffset arguments in numeric(), alphabetic(), binsearch()

Usage:

 numeric   ($fh, $value [ , \&munge [ , $minoffset, $maxoffset ] ]);
 alphabetic($fh, $value [ , \&munge [ , $minoffset, $maxoffset ] ]);
 binsearch ($fh, $value, \&compare [ , \&munge [ , $minoffset, $maxoffset ] ]);

This limits the range within which binary searching is done. This also avoids
using stat() on the filehandle. Useful when only want to search part of a file
(like only in __DATA__ section of a Perl source file) or when using a tied
filehandle which does not trap stat().

=back

=for Pod::Coverage ^(.+)$

=for stopwords Stig refactored ta da hh mm ss dd mm yyyy recognised

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/F*

%changelog
