%define module_version 0.003
%define module_name File-Which-Patch-Hide
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/Which.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Module/Patch.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(base.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: Hide some programs from File::Which
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/File-Which-Patch-Hide

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module can be used to simulate the absence of certain programs. This module
works by patching (wrapping) the File::Which manpage's `which()' routine to remove the
result if the programs that want to be hidden are listed in the result. So only
programs that use `which()' will be fooled.

An example of how I use this module: the Nodejs::Util manpage has a routine
`get_nodejs_path()' which uses `File::Which::which()' to check for the
existence of node.js binary. The `get_nodejs_path()' routine is used in some of
my test scripts to optionally run tests when node.js is available. So to
simulate a condition where node.js is not available:

 %% PERL5OPT=-MFile::Which::Patch::Hide=-prog,'node;nodejs' prove ...
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/F*

%changelog
