%define module_name Filter-Cleanup
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Keyword/Declare.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test2/Bundle/Extended.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: A stackable way to deal with error handling
Group: Development/Perl
License: perl
URL: https://github.com/sysread/Filter-Cleanup

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JE/JEFFOBER/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Filter::Cleanup provides a simple way to deal with cleaning up after multiple
error conditions modeled after the D programming language's `scope(exit)'
mechanism.

Each `cleanup' block operates in essentially the same manner as a `finally'
block in languages supporting try/catch/finally style error handling.

`cleanup' blocks may be placed anywhere in a scope. All statements lexically
scoped after the `cleanup' block will be wrapped in an `eval'. Should an error
be triggered within the block, the `cleanup' statement will be called before
any error is rethrown (using `croak').

Within the `cleanup' block, the status of `$@' may be inspected normally.

Multiple `cleanup' blocks stack, and each *MUST* be followed by a semi-colon
to ensure proper organization of the outputted code. `cleanup's are executed
in reverse order (it's a stack, see?) and may be nested, although this defeats
the purpose. The reason for reverse execution is that each cleanup represents
another nested level of evals and clean-up code.

Take the following code:

    use Filter::Cleanup;
    
    sub example {
        cleanup { print "FOO" };
        print "BAR";
        return 1;
    }

This is roughly the output of the source filter:

    sub example {
        my $result = eval {
            print "BAR";
            return 1;
        };
        
        my $error = $@;
        
        print "FOO";
        
        if ($error) {
            croak $error;
        } else {
            $result; # returns 1
        }
    }

Now with multiple cleanups:

    use Filter::Cleanup;
    
    sub example {
        cleanup { print "FOO" };
        cleanup { print "BAZ" };
        print "BAR";
        return 1;
    }
    
The following code would be generated:

    sub example {
        my $result = eval {
            my $result = eval {
                print "BAR";
                return 1;
            };
            
            my $error = $@;
            
            print "BAZ";
            
            if ($error) {
                croak $error;
            } else {
                $result;
            }
        };
        
        my $error = $@;
        
        print "FOO";
        
        if ($error) {
            croak $error;
        } else {
            $result; # returns 1
        }
    }

Internally, PPI is used to parse the module and generate the new code. This is
because there are so many different forms which could proceed a `cleanup' block
that there is no more efficient way to ensure that valid code is emitted. PPI
has proven to be stable, robust, and very reasonably efficient.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/F*

%changelog
