%define module_name Finance-BankVal-UK
BuildRequires: dos2unix
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON.pm) perl(LWP/UserAgent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.9
Release: alt1
Summary: Perl extension for accessing Unified Software's bankValUK web
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/U/UN/UNIFIEDSW/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module handles all of the restful web service calls to Unified Software's
BankValUK service. It also handles fail over to the back up services transparently to the
calling script. It can be called either in a procedural sense or an OO one (see synopsis)

The exposed method &bankValUK(); takes a number of parameters including;

1: Format _- the response format (either xml, json or csv)

2: Sort code_- 6 digit number either 00-00-00, 00 00 00 or 000000

3: Account no._- 6 to 12 digit (unseperated i.e. 00000000)

4: UserID_- available from www.unifiedsoftware.co.uk

5: PIN__- available from www.unifiedsoftware.co.uk

(UserID and PIN are available from http://www.unifiedsoftware.co.uk/freetrial/free-trial-home.html)

The order of the parameters must be as above although supplying an account number is optional.
The UserID and PIN can also be stored in the LoginConfig.txt file bundled with this module, the
use of this file saves passing the PIN and user ID data with each call to bankValUK.
For example a call to validate a UK bank account passing the user ID and PIN as parameters
and printing the reply to console should follow this form:

=====================================================================

 #!/usr/bin/perl

 use Finance::BankVal::UK qw(&bankValUK);

 my $ans = bankValUK('XML','01-02-03','12345678','xmpl123','12345');

 print $ans;

=====================OR for Object Orientation=======================

 use Finance::BankVal::UK

 my $bvObj = Finance::BankVal::UK->new();
 my $ans = $bvObj->bankValUK('XML','01-02-03','12345678','xmpl123','12345');

 print $ans;

=====================================================================

valid parameter lists are:-

bankValUK('$format','$sortcode','$account no.','$userID','$PIN');

bankValUK('$format','$sortcode','$userID','$PIN');

bankValUK('$format','$sortcode','$account no.');

bankValUK('$format','$sortcode');

n.b. the last two parameter lists require that the user ID and PIN are stored
in the *LoginConfig.txt* file bundled with this module.



%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install
# trailing <CR> in interpreter: #!/usr/bin/perl<CR>
for dir in %buildroot%_bindir %buildroot%perl_vendor_archlib %buildroot%perl_vendor_privlib ; do
    if [ -d $dir ]; then
    	find $dir -type f -executable | while read f; do
	  case `file $f` in
	    *perl*) dos2unix $f ;;
	  esac
	done
    fi
done


%files
#doc README Changes Perl Module Guide BankValUK.pdf LoginConfig.txt
%perl_vendor_privlib/F*

%changelog
