%define module_name Finance-Nadex
%set_perl_req_method relaxed
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Response.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(Test/Exception.pm) perl(Test/LWP/UserAgent.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.12
Release: alt1
Summary: Interact with the North American Derivatives Exchange
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MH/MHANDISI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Easily create orders, cancel orders, retrieve orders and retrieve positions on the North American Derivatives Exchange


    use Finance::Nadex;

    my $client = Finance::Nadex->new();

    # must login to perform any actions, including simply querying market info
    $client->login(username => 'yourusername', password => 'yourpassword');
    
    # get the available balance in the account
    my $balance = $client->balance();
    
    # get a quote for GBP/USD
    my $quote = $client->get_quote('instrument' => 'GBP/USD');

    # $quote may now be (for example), 1.5010
    
    # retrieve the epic (Nadex-assigned contract unique identifier) for the
    # Daily, 3pm, GBP/USD > 1.5120 contract
    my $epic = $client->get_epic( period => 'Daily', market => 'Forex (Binaries)', time => '3pm', instrument => 'GBP/USD', strike => '1.5120');
    
    # suppose $epic now contains 'NB.D.GBP-USD.OPT-23-17-23Jan15.IP';
    # create an order to buy 3 of those contracts for $34.50 each
    my $order_id = $client->create_order( price => '34.50', direction => 'buy', epic => $epic, size => 3 );
    
    # check the status of the order using the order id returned by the exchange;
    # this call will return undef if the order doesn't exist; the order may not exist
    # because the order was rejected by the exchange or because it was filled immediately
    # and therefore is no longer a working order
    my $order = $client->retrieve_order( id => $order_id );
    
    # let's assume the order was created and is still a working (or pending) order;
    # get the details of the order using the accessor methods provided by Finance::Nadex::Order
    print join(" ", $order->direction, $order->size, $order->contract, $order->price), "\n";

    # suppose the order has now been filled; this means we have one open position;
    # get the open positions
    my @positions = $client->retrieve_positions();
    
    # @positions now has 1 element which is a Finance::Nadex::Position; get its details
    print join(" ", $positions[0]->id, ...
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README examples
%perl_vendor_privlib/F*

%changelog
