# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Keyword/Simple.pm) perl(Readonly.pm) perl(Text/Balanced.pm)
# END SourceDeps(oneline)
%define module_name Fixed
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: a readonly variable that you can assign to
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Fixed

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBYINK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`Fixed' is a little like the Readonly manpage; the main difference is that you can
assign to fixed variables.

What?! Then how are they fixed?

Because you can only assign to them once!

   use 5.012;
   use strict;
   use warnings;
   use Fixed;
   
   fix $x;  # declared but not initialized
   
   given ($author) {
      when ("Adams")   { $x = 42    }  # ok
      when ("Heller")  { $x = 22    }  # ok
      default          { $x = undef }  # ok
   }
   
   $x = 99; # croaks, even when $x is undef

Note that Fixed differentiates between a variable which has no value, and
a variable explicitly set to undef.

`Fixed' does not currently support arrays and hashes. (See "Internals"
below for the reason.) You can of course assign an arrayref or hashref to
a fixed variable, but this does not fix the contents of the array or hash.
Use the Readonly manpage if you want readonly arrays and hashes.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes CREDITS CONTRIBUTING README LICENSE COPYRIGHT
%perl_vendor_privlib/F*

%changelog
