Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Pod/Usage.pm) perl(Term/ProgressBar.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Flickr-Upload
Epoch:          2
Version:        1.6
Release:        alt2_23
Summary:        Flickr.com upload module and script
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/Flickr-Upload
Source0:        https://cpan.metacpan.org/authors/id/S/SS/SSEVERIN/Flickr-Upload-%{version}.tar.gz
Patch0:         perl-Flickr-Upload-remotetests.patch
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Run-time:
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Digest/MD5.pm)
BuildRequires:  perl(Encode.pm)
BuildRequires:  perl(Flickr/API.pm)
# Getopt::Long 1 not used at tests
BuildRequires:  perl(HTTP/Request/Common.pm)
BuildRequires:  perl(LWP/UserAgent.pm)
BuildRequires:  perl(Net/OAuth.pm)
# Pod::Usage >= 1 not used at tests
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(URI/Escape.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  perl(XML/Simple.pm)
# Optional run-time:
# Term::ProgressBar 2.00 not used at tests
# Tests:
BuildRequires:  perl(List/Util.pm)
BuildRequires:  perl(Test/More.pm)
Requires:       perl(Flickr/API.pm) >= 1.090
Requires:       perl(Getopt/Long.pm) >= 1
Requires:       perl(HTTP/Request/Common.pm) >= 1
Requires:       perl(LWP/UserAgent.pm) >= 1
Requires:       perl(Net/OAuth.pm) >= 0.280
Requires:       perl(Pod/Usage.pm) >= 1
Requires:       perl(XML/Simple.pm) >= 2
# Optional run-time:
Requires:       perl(Term/ProgressBar.pm) >= 2.0

# Remove under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(\(Flickr.API\|Getopt.Long\|HTTP.Request.Common\|LWP.UserAgent\|Pod.Usage\|XML.Simple\|Net.OAuth\).pm)/d

%description
Module and script for uploading images to flickr.com web gallery.

%prep
%setup -q -n Flickr-Upload-%{version}
%patch0 -p0 -b .remotetests

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
find $RPM_BUILD_ROOT -depth -type d -exec rmdir {} 2>/dev/null \;
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc ChangeLog README
%{perl_vendor_privlib}/*
%{_bindir}/flickr_upload
%{_mandir}/man1/flickr_upload.1*


%changelog
