Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Font-TTFMetrics
Version:        0.1
Release:        alt2_39
Summary:        Parser for the TTF file
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/Font-TTFMetrics
Source0:        https://cpan.metacpan.org/modules/by-module/Font/Font-TTFMetrics-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(Test/More.pm)
Source44: import.info

%description
Font::TTFMetrics encapsulates the font metrics of a true type font file. A
true type font file contains several tables which need to be parsed before
any useful information could be gathered about the font. There is the
excellent module for parsing TTF font in CPAN by Martin Hosken, Font::TTF.
But in my opinion the use of Font::TTF requires intimate knowledge of TTF
font format. This module was written to support the use of TTF in Pastel 2D
graphics library in Perl. Three factors prompted me to write this module:
first, I required a fast module to access TTF file. Second, all the access
required was read-only. Last, I wanted a user friendly, higher level API to
access TTF file.

%prep
%setup -q -n Font-TTFMetrics-%{version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install

make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT

find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
find $RPM_BUILD_ROOT -depth -type d -exec rmdir {} 2>/dev/null \;

# %{_fixperms} $RPM_BUILD_ROOT/*
chmod a-x $RPM_BUILD_ROOT/%{perl_vendor_privlib}/Font/TTFMetrics.pm

%check
make test

%files
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
