%set_perl_req_method relaxed
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/LongString.pm) perl(Text/Wrap.pm) perl(Type/Utils.pm) perl(Types/Standard.pm) perl(XML/LibXML/Augment.pm)
# END SourceDeps(oneline)
%define module_name FreeMind-Document
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: representation of a FreeMind-style mind map document
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/FreeMind-Document

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBYINK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is a subclass of the XML::LibXML::Document manpage providing the following
additional methods:

=over

=item `load($type, $source)'

Constructor. If `$type' is `"IO"' then `$source' should be a
filehandle. If `$type' is `"location"' then `$source' should
be a file name or URL. If If `$type' is `"string"' then
`$source' should be a scalar string containing XML.

If the XML being loaded is a FreeMind mind map document, returns an instance
of FreeMind::Document. Otherwise returns an instance of XML::LibXML::Document.

=item `root'

Returns the centre-most node of the mind map as a the FreeMind::Node manpage.

=item `toHash'

`$document->toHash' is a shortcut for `$document->root->toHash'.

=item `toText($indent, $width)'

`$document->toText' is a shortcut for `$document->root->toText'.

=back

As this is an XML::LibXML::Document, you have all the standard methods for
traversing the document such as `findnodes' and `getElementsByTagName',
but the elements returned by these methods will be the FreeMind::Map manpage,
the FreeMind::Node manpage, etc objects rather than the XML::LibXML::Element manpage objects.

The XML elements provide accessors for XML attributes. For example, given
this XML element:

   <node
      CREATED="1365159476220"
      ID="ID_326312292"
      MODIFIED="1365441636185"
      POSITION="right"
      TEXT="documentation" />

You can call `$element->created' to get the element's creation date
as an integer. Call it with an argument to write to the attribute:

   $element->created($some_time);

To remove the attribute, pass an explicit `undef' as an argument. These
attribute accessors perform a limited amount of validation. The standard
XML::LibXML::Element `getAttribute', `setAttribute' and `removeAttribute',
but these will perform no validation.

(Incidentally, FreeMind dates are milliseconds since the Unix epoch. The
setters will happily coerce from the DateTime manpage objects though.)

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CREDITS CONTRIBUTING COPYRIGHT TODO LICENSE Changes TODO.mm README examples
%perl_vendor_privlib/F*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
