%define module_name Future-Buffer
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Future.pm) perl(Module/Build.pm) perl(Test/More.pm) perl(Test2/V0.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: a string buffer that uses Futures
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PEVANS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Objects in this class provide a string buffer, on which operations return
the Future manpage instances which will complete when data is available. Data can be
inserted into the buffer either in a push-based manner by calling the `write'
method, or in a pull-based manner by providing it with a `fill' callback by
which it can request data itself. This flexibility allows the buffer to act as
an adapter between push- and pull-based providers and consumers.

Each `read'-like method returns a the Future manpage which will complete once there
are enough bytes in the buffer to satisfy the required condition. The buffer
behaves somewhat like a pipe, where bytes provided at the writing end (either
by the `write' method or the `fill' callback) are eventually consumed at the
reading end by one of the `read' futures.

Multiple `read' futures can remain pending at once, and will be completed in
the order they were created when more data is eventually available. Thus, any
call to the `write' method to provide more data can potentially result in
multiple futures becoming ready.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/F*

%changelog
