# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(GD.pm) perl(GD/Barcode.pm) perl(Image/Magick.pm) perl(Pod/Usage.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 1.03
%define module_name GD-Barcode-Image
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.03
Release: alt1
Summary: Script to create images of barcodes
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AV/AVINASH/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module adds minor extensions in functionality to the
GD::Barcode module.  See the documentation for GD::Barcode and all its
barcode symbology types for additional information on the use of this
module.


=over 4

=item new()

*$oGdBarIm* = GD::Barcode::Image->new(*$sType*, *$sTxt*, *\%%rhPrm*);

Constructor. 
Creates a GD::Barcode::Image object for text *$sTxt*, for barcode
symbology type *$sType*. 
Additional parameters can be provided for QRcode type - see
GD::Barcode::QRcode module in the GD::Barcode package.

=item plot_imagick()

*$oGdIm* = $oGdBarIm->plot_imagick([Height => *$iHeight*, NoText => *0 | 1*]);

creates Image::Magick object for the barcode object.
*$iHeight* is height of the image. If *NoText* is 1, the image has no text image of *$sTxt*.
Height and NoText parameters will not apply to the QRcode barcode type.

=item plot_gd()

*$oGd* = $oGdBarIm->plot_gd([Height => *$iHeight*, NoText => *0 | 1*]);

Same as plot_imagick() except that a GD image object is returned.

=item $GD::Barcode::errStr

has error message. This is same error mechanism as in the GD::Barcode
module.

=item barcodegen

This module also includes the command-line script barcodegen that can
be used to create barcode images in various formats: GIF, JPEG, PNG, EPS,
PDF.

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/G*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
